<!-- Topbar -->
<div class="topbar">
  <h3>Authority List</h3>
  <div class="user-profile">
    <span class="fw-semibold">Chetan Lathigara</span>
    <img src="https://cdn-icons-png.flaticon.com/512/847/847969.png" width="100" alt="User Avatar">
  </div>
</div>

<!-- Main Content -->
<div class="content">
  <div class="card">
    <div class="card position-relative shadow-sm rounded-4">
    <!-- Add button fixed inside card -->
      <a href="<?= base_url('authority/create') ?>" class="fab-top">
          <i class="fa-solid fa-plus"></i>
      </a>
      <div class="card-body">
        <div class="table-responsive">
          <table class="table align-middle text-center mb-0">
              <thead>
                  <tr>
                  <!--<th>ID</th>-->
                      <th>Sr.No</th>
                      <th style="text-align:left;">Authority Name</th>
                      <th style="text-align:left;">Alias</th>
                      <th>Created On</th>
                      <th>Action</th>
                  </tr>
              </thead>
            <tbody>
              <?php if(empty($authorities)): ?>
              <tr>
                  <td colspan="7" class="text-center">No authority types found</td>
              </tr>
              <?php else: ?>
                  <?php foreach($authorities as $row): ?>
                  <tr>
                      <!--<td><?= $row->id ?></td>-->
                      <td style="text-align:left;"><?= $row['authority_name'] ?></td>
                      <td style="text-align:left;"><?= $row['alias'] ?></td>
                      <td><?=  date("d-M-Y", strtotime($row['creation_date'])); ?></td>
                      <td>
                          <a href="<?= base_url('authority/edit/'.$row['id']) ?>" class="btn btn-warning btn-icon"><i class="fas fa-edit"></i></a>
                          <a href="<?= base_url('authority/delete/'.$row['id']) ?>" class="btn btn-danger btn-icon" onclick="return confirm('Are you sure to Delete?')"><i class="fas fa-trash-alt"></i></a>
                          <?php if ($row->status == 'ACTIVE'): ?>
                                  <a href="<?= site_url('authority/toggle_status/'.$row->id); ?>" 
                                  class="btn btn-success btn-icon rounded-circle" 
                                  onclick="return confirm('Are you sure to deactivate?');" title="Active">
                                      <i class="fas fa-check"></i>
                                  </a>
                          <?php else: ?>
                                  <a href="<?= site_url('authority/toggle_status/'.$row->id); ?>" 
                                  class="btn btn-secondary btn-icon rounded-circle"
                                  onclick="return confirm('Are you sure to activate?');" title="Inactive">
                                      <i class="fas fa-times"></i>
                                  </a>
                          <?php endif; ?>
                      </td>
                  </tr>
                  <?php endforeach; ?>
              <?php endif; ?>
              </tbody>
          </table>
        </div>
      </div>
    </div>
  </div>
</div>
