<?php
class Upload_model extends CI_Model {

	public function getAuthorities()
	{
		return $this->db->select('a.id as authority_id, a.authority_name,a.alias_name')
    ->from('authority a')
    ->join(
        'sub_type st',
        'CAST(NULLIF(st.authority_id, \'\') AS INTEGER) = a.id',  // handle empty strings safely
        'left',  // ✅ use LEFT JOIN so all authorities show
        false     // don't escape
    )
	 ->where('a.status', '1') 
	 ->where('a.is_delete', '0') 
	 ->order_by('a.authority_name','asc')
	 ->group_by('a.id, a.authority_name')
    ->get()
    ->result_array();

	}

    /*public function getTypesByAuthority($authority_id, $company_id,$month, $year)
	{
		// Step 1: Get all sub types for this authority
		$this->db->select('id, type_name');
		$this->db->from('sub_type');
		$this->db->where('authority_id', $authority_id);
		$this->db->where('status', '1');
		$subtypes = $this->db->get()->result_array();

		$pending = [];

		foreach ($subtypes as $sub) {

			// Step 2: Fetch mandatory documents linked to this subtype
			$this->db->select('document_id');
			$this->db->from('mandatory_documents');
			$this->db->where('type_id', $sub['id']);
			$mandatory_docs = $this->db->get()->result_array();

			if (empty($mandatory_docs)) {
				// If no mandatory docs → always show this subtype
				$pending[] = $sub;
				continue;
			}

			$doc_ids = array_column($mandatory_docs, 'document_id');

			// Step 3: Check uploaded docs for this subtype + company
			$this->db->select('COUNT(DISTINCT document_id) AS uploaded_count', false);
			$this->db->from('uploaded_documents');
			$this->db->where_in('document_id', $doc_ids);
			$this->db->where('company_id', $company_id);
			$this->db->where('document_month', $month);
			$this->db->where('document_year', $year);
			$this->db->where('is_deleted', 0);
			$uploaded = $this->db->get()->row();

			$uploaded_count = (int) $uploaded->uploaded_count;
			$total_required = count($doc_ids);

			// Step 4: Debug log (optional)
			// log_message('debug', "Subtype {$sub['type_name']} → {$uploaded_count}/{$total_required} uploaded");

			// Step 5: Include subtype if not all uploaded
			if ($uploaded_count < $total_required) {
				$pending[] = $sub;
			}
		}

		return $pending;
	}*/

	public function getTypesByAuthority($authority_id, $company_id,$month, $year)
    {
        //working query for uploaded document check for month and year
        
        /*$this->db->distinct();
        $this->db->select('st.id, st.type_name, st.frequency');
        $this->db->from('sub_type st');
        $this->db->join('mandatory_documents md', 'st.id = md.type_id', 'inner');

        // Add NOT EXISTS condition manually
        $not_exists = "
            NOT EXISTS (
                SELECT 1 
                FROM uploaded_documents ud
                WHERE ud.type_id = st.id
                AND ud.document_id = md.document_id
                AND ud.company_id = " . $this->db->escape($company_id) . "
                AND ud.document_year = " . $this->db->escape($year) . "
                AND ud.document_month = " . $this->db->escape($month) . "
            )
        ";

        $this->db->where('st.authority_id', $authority_id);
        $this->db->where('st.status', '1');
        $this->db->where($not_exists, NULL, FALSE); // Raw condition

        $query = $this->db->get();
        return $query->result();*/

        $this->db->distinct();
        $this->db->select('st.id, st.type_name, st.frequency');
        $this->db->from('sub_type st');
        $this->db->join('mandatory_documents md', 'st.id = md.type_id', 'inner');

        // Condition for documents not uploaded based on frequency
        $not_uploaded_condition = "
            (
                -- Case 1: One-time documents → must never be uploaded
                (st.frequency = 'One Time' AND 
                    NOT EXISTS (
                        SELECT 1 FROM uploaded_documents ud1
                        WHERE ud1.type_id = st.id
						AND ud1.is_deleted = 0
                        AND ud1.company_id = " . $this->db->escape($company_id) . "
                    )
                )

                OR 

                (st.frequency = 'Yearly' AND 
                    NOT EXISTS (
                        SELECT 1 FROM uploaded_documents ud3
                        WHERE ud3.type_id = st.id
                        AND ud3.document_id = md.document_id
						AND ud3.is_deleted = 0
                        AND ud3.company_id = " . $this->db->escape($company_id) . "
                        AND ud3.document_year = " . $this->db->escape($year) . "
                    )
                )

                OR

                -- Case 2: Other frequencies → not uploaded for the given month & year
                (st.frequency NOT IN ('One Time', 'Yearly') AND 
                    NOT EXISTS (
                        SELECT 1 FROM uploaded_documents ud2
                        WHERE ud2.type_id = st.id
                        AND ud2.document_id = md.document_id
						AND ud2.is_deleted = 0
                        AND ud2.company_id = " . $this->db->escape($company_id) . "
                        AND ud2.document_year = " . $this->db->escape($year) . "
                        AND ud2.document_month = " . $this->db->escape($month) . "
                    )
                )
            )
        ";

        $this->db->where('st.authority_id', $authority_id);
        $this->db->where('st.status', '1');
        $this->db->where($not_uploaded_condition, NULL, FALSE);

        return $this->db->get()->result();
    }

    public function getDocumentsByType($type_id)
    {
        $this->db->select('d.id, d.document_name, md.mandatory');
        $this->db->from('mandatory_documents md');
        $this->db->join('documents d', 'd.id = md.document_id', 'left');
        $this->db->where('md.type_id', $type_id);
		echo $this->db->last_query();
        return $this->db->get()->result_array();
    }

    public function saveUpload($data)
    {
        return $this->db->insert('uploaded_documents', $data);
    }
	public function get_missing_documents_by_company($user_id, $month = null, $year = null)
	{
		$params = [$user_id];
		$monthYearFilter = '';

		// Build month/year condition used inside CASE WHEN
		if (!empty($month) && !empty($year)) {
			$monthYearFilter = "AND LPAD(u.document_month::text, 2, '0') = ? AND u.document_year::text = ?";
			$params[] = $month;
			$params[] = $year;
		} elseif (!empty($year)) {
			$monthYearFilter = "AND u.document_year::text = ?";
			$params[] = $year;
		} elseif (!empty($month)) {
			$monthYearFilter = "AND LPAD(u.document_month::text, 2, '0') = ?";
			$params[] = $month;
		}

		$sql = "
			WITH user_companies AS (
				SELECT 
					unnest(string_to_array(user_company, ','))::int AS company_id,
					unnest(string_to_array(user_type, ','))::int AS type_id
				FROM \"users\"
				WHERE id = ?
			),
			all_docs AS (
				SELECT 
					uc.company_id,
					uc.type_id,
					md.document_id,
					d.document_name,
					c.company_name,
					t.type_name,
					
					CASE 
						WHEN u.document_id IS NULL THEN 1
						ELSE 0
					END AS is_missing,

					CASE 
						WHEN u.document_id IS NOT NULL 
							$monthYearFilter
						THEN 1
						ELSE 0
					END AS is_uploaded

				FROM 
					user_companies uc
				JOIN mandatory_documents md 
					ON uc.type_id = md.type_id
				JOIN documents d 
					ON md.document_id = d.id
				LEFT JOIN uploaded_documents u 
					ON u.company_id = uc.company_id 
					AND u.type_id = uc.type_id 
					AND u.document_id = md.document_id
				LEFT JOIN company c 
					ON uc.company_id = c.id
				LEFT JOIN sub_type t 
					ON uc.type_id = t.id
			)

			SELECT 
				company_id,
				company_name,
				type_id,
				type_name,
				string_agg(d.document_name, ', ' ORDER BY d.document_name) FILTER (WHERE is_missing = 1) AS missing_documents,
				COUNT(*) FILTER (WHERE is_missing = 1) AS missing_count,
				COUNT(*) FILTER (WHERE is_uploaded = 1) AS uploaded_count
			FROM all_docs d
			GROUP BY company_id, company_name, type_id, type_name
			ORDER BY company_name, type_name;
		";

		$query = $this->db->query($sql, $params);
		return $query->result_array();
	}

}