<?php
defined('BASEPATH') OR exit('No direct script access allowed');

class Type extends CI_Controller {

	/**
	 * Index Page for this controller.
	 *
	 * Maps to the following URL
	 * 		http://example.com/index.php/welcome
	 *	- or -
	 * 		http://example.com/index.php/welcome/index
	 *	- or -
	 * Since this controller is set as the default controller in
	 * config/routes.php, it's displayed at http://example.com/
	 *
	 * So any other public methods not prefixed with an underscore will
	 * map to /index.php/welcome/<method_name>
	 * @see https://codeigniter.com/userguide3/general/urls.html
	 */
	public function index()
	{
		redirect('type/allType');
	}
	
	public function allType()
    {   
		$this->session->set_userdata('menu','type');
		$login_id = $this->session->userdata('id');
		if($login_id=='') {
			redirect('login');
		}
		
		//$sql="select s.*,a.authority_name from sub_type s LEFT JOIN authority a ON a.id = CAST(s.authority_id AS INTEGER) order by type_name asc ";  

		$sql = "SELECT 
				s.*, 
				a.authority_name, 
				string_agg(d.document_name, ', ') AS document_names,
				u.first_name,
				u.last_name,
				u.email_id
				FROM sub_type s
				LEFT JOIN authority a ON a.id = CAST(NULLIF(s.authority_id, '') AS INTEGER)
				LEFT JOIN documents d ON CAST(d.id AS TEXT) = ANY(string_to_array(s.document_name, ','))
				LEFT JOIN users u ON CAST(u.id as TEXT) = s.created_by
				where s.status = '1' 
				GROUP BY s.id, a.authority_name,u.first_name,u.last_name,u.email_id
				ORDER BY s.type_name ASC";
		
		$query = $this->db->query($sql);
		$business_data = $query->result_array();
		$frequency = PAYMENT_OPTIONS;
		
		$this->load->view('templates/header');
		$this->load->view('type/all_type',array('authority_list'=>$business_data));
		//$this->load->view('templates/footer');

	}
	public function addType() {
		$this->session->set_userdata('menu','type');
		$login_id = $this->session->userdata('id');
		if($login_id=='') {
			redirect('login');
		}
		$sql="select * from authority where status='1' order by id asc ";  
		$query = $this->db->query($sql);
		$business_data = $query->result_array();
		
		$document_sql = "select * from documents where status='1'";
		$document_query = $this->db->query($document_sql);
		$document_data = $document_query->result_array();
		
		$frequency = PAYMENT_OPTIONS;
		$this->load->view('templates/header');
		$this->load->view('type/add_type',array('authority'=>$business_data,'frequency'=>$frequency,'document_data'=>$document_data));
		//$this->load->view('templates/footer');
	}
	
	public function saveType() {
		
		$this->session->set_userdata('menu','type');
		$login_id = $this->session->userdata('id');
		
		if($login_id=='') {
			redirect('login');
		}

		//echo $this->session->userdata('full_name');

		//echo '<pre>'; print_r($_POST);exit;
		$post = $this->input->post();
		$sub_type = $post['sub_type'];
		$alias_name = $post['alias'];
		$authority_id = $post['authority_id'];
		$frequency = $post['frequency'];
		$doc_type = $post['doc_type'];
		$document_date = $post['document_date'] ?? null;
		$doc_start_date = $post['document_start_date'];
		$due_month = $post['due_month'];

		if($due_month == 'same')
			$due_month = 0;
		else 
			$due_month = 1;
		//$frequency_start_date = $post['frequency_start_date'] ?? null;
		//$monthly_days = $post['monthly_days'] ?? null;
		if($frequency=='Monthly') {
            $frequency_start_date = $_POST['monthly_days'];
        }
        else {
            $frequency_start_date = $_POST['frequency_start_date'];
        }
		$created_by = $this->session->userdata('full_name') ?? null;

		$documents = $post['document'] ?? []; // selected documents
		$mandatory = $post['mandatory'] ?? []; // mandatory mapping

		// Insert into type table
		$typeData = [
			'type_name' => $sub_type,
			'alias_name' => $alias_name,
			'authority_id' => $authority_id,
			'frequency' => $frequency,
			'doc_type' => $doc_type,
			'frequency_start_date' => $frequency_start_date,
			'document_name'=>implode(',',$documents),
			'document_start_date' => $doc_start_date,
			'created_by'=> $login_id,
			'due_in_same_next_month' => $due_month
		];
		
		//echo $document_date;exit;
		if (!empty($document_date)) {
			$typeData['document_expiry_date'] = $document_date;
		}

		$typeData['status'] = 1; // Add status to the array

		$this->db->insert('sub_type', $typeData);
		$type_id = $this->db->insert_id();

		// Insert into type_documents table
		foreach ($documents as $docId) {
			$this->db->insert('mandatory_documents', [
				'type_id' => $type_id,
				'document_id' => $docId,
				'mandatory' => isset($mandatory[$docId]) ? $mandatory[$docId] : 0
			]);
		}

		//redirect('type');
		
		$this->session->set_flashdata('message_name', 'Sub Type Created Successfully');
		
		redirect('type');	
	}
	public function deleteType($id)
	{
		$this->session->set_userdata('menu','type');
		$login_id = $this->session->userdata('id');
		
		if($login_id=='') {
			redirect('login');
		}

		//Check is authoiry is mapped with any type and user
        if ($this->id_exists('uploaded_documents', $id)) {
            $this->session->set_flashdata('message_type', 'error');
            $this->session->set_flashdata('message_name', 'Delete not allowed — Document head in use.');
            redirect('type/allType');
            return;
        }
		
		$query = $this->db->get_where('sub_type', ['id' => $id]);

		if ($query->num_rows() === 0) {
			redirect('type');
		} else {
			//echo "in else";exit;
			$this->db->where('id', $id)->update('sub_type', ['status' => 0]);
			$this->session->set_flashdata('message_name', 'Type Deleted Successfully');
			$this->session->set_flashdata('message_type', 'success'); // optional: success, error, info, warning
			redirect('type/allType');
		}
	}
	
	
	public function editType($id) {
		
		 $login_id = $this->session->userdata('id');
		if ($login_id == '') {
			redirect('login');
		}
		$this->session->set_userdata('menu', 'type');

        if ($this->id_exists('uploaded_documents', $id)) {
            $this->session->set_flashdata('message_type', 'error');
            $this->session->set_flashdata('message_name', 'Edit not allowed — Document head in use.');
            redirect('type/allType');
            return;
        }

		// Get type data
		$sql = "SELECT * FROM sub_type WHERE id = ?";
		$type_query = $this->db->query($sql, array($id));
		$type_data = $type_query->row_array(); // single row is enough

		if (empty($type_data)) {
			redirect('type/allType');
		}

		// Get authority
		$sql1 = "SELECT * FROM authority WHERE status = '1'";
		$query1 = $this->db->query($sql1);
		$authority_data = $query1->result_array();

		// Get all documents
		$document_sql = "SELECT * FROM documents WHERE status='1'";
		$document_query = $this->db->query($document_sql);
		$document_data = $document_query->result_array();

		// ✅ Get already assigned documents (with mandatory flag)
		$assigned_sql = "SELECT document_id, mandatory FROM mandatory_documents WHERE type_id = ?";
		$assigned_query = $this->db->query($assigned_sql, array($id));
		$assigned_documents = $assigned_query->result_array();
		
		// Convert assigned docs into [doc_id => mandatory]
		$selected_docs = [];
		foreach ($assigned_documents as $doc) {
			$selected_docs[$doc['document_id']] = $doc['mandatory'];
		}
		$frequency = PAYMENT_OPTIONS;

		$this->load->view('templates/header');
		$this->load->view(
			'type/edit_type',
			array(
				'authority_data'   => $authority_data,
				'type_data'        => $type_data,
				'frequency'        => $frequency,
				'document_data'    => $document_data,
				'selected_docs'    => $selected_docs // ✅ pass to view
			)
		);
	}
		
	
	public function updateType() {
		$login_id = $this->session->userdata('id');
		if($login_id=='') {
			redirect('login');
		}
		$this->session->set_userdata('menu','type');
		$id = $_POST['type_id'];
		//echo '<pre>'; print_r($_POST);exit;
		$sub_type = $_POST['sub_type'];
		$alias_name = $_POST['alias'];
		$monthly_days = $_POST['monthly_days'];
		$authority_id = $_POST['authority_id'];
		$frequency = $_POST['frequency'];
		$doc_type = $_POST['doc_type'];
		$due_month = $_POST['due_month'];

		if($due_month == 'same'){
			$due_month = 0;
		} else {
			$due_month = 1;
		}	

		if($frequency=='Monthly') {
			$frequency_start_date = $_POST['monthly_days'];
		}
		else {
			$frequency_start_date = $_POST['frequency_start_date'];
		}
		$document_expiry_date = $_POST['document_expiry_date'];
		$document_date = $_POST['document_date'];
		$document =  implode(',',$_POST['document']);
		//$created_by = $this->session->userdata('full_name') ?? null;
		//$document =  implode(',', $_POST['document']);
		
		//$sql = "update sub_type set type_name='$sub_type',authority_id='$authority_id', frequency = '$frequency',doc_type='$doc_type',frequency_start_date='$frequency_start_date', document_expiry_date='$document_expiry_date',document_name='$document',alias_name='$alias_name'  where id='$id'";
		//$query1 = $this->db->query($sql);
		$this->db->where('id', $id);
		$this->db->update('sub_type', array_merge([
    'type_name'            => $sub_type,
    'authority_id'         => $authority_id,
    'frequency'            => $frequency,
    'status'               => 1,
    'doc_type'             => $doc_type,
    'frequency_start_date' => $frequency_start_date,
    'document_name'        => $document,
    'alias_name'           => $alias_name,
    'created_by'           => $login_id,
	'due_in_same_next_month' => $due_month
], !empty($document_date) ? ['document_expiry_date' => $document_date] : []));

		$delete_query  = "delete from mandatory_documents where type_id = '$id'";
		$delete_data = $this->db->query($delete_query);
		
		$documents = $_POST['document'] ?? []; // selected documents
		$mandatory = $_POST['mandatory'] ?? []; // mandatory mapping

		// Insert into type_documents table
		foreach ($documents as $docId) {
			$this->db->insert('mandatory_documents', [
				'type_id' => $id,
				'document_id' => $docId,
				'mandatory' => isset($mandatory[$docId]) ? $mandatory[$docId] : 0
			]);
		}
		$this->session->set_flashdata('message_name', 'Type Details Successfully Updated');

		redirect('type/allType');
		
	}
	
	public function viewProject($id) {
		$login_id = $this->session->userdata('id');
		if($login_id=='') {
			redirect('login');
		}
		
		$sql="select * from projects where id= '$id'";   
		$project_query = $this->db->query($sql);
		$project_data = $project_query->result_array();
		$this->load->view('templates/layout');
		$this->load->view('project/view_project',array('project_data'=>$project_data));
	}
	
	public function changeStatus()
	{
		$id     = $this->input->post('id');
		$status = $this->input->post('status');

		if ($this->id_exists('uploaded_documents', $id)) {
            echo json_encode([
				'success' => false,
				'message' => 'Deactivation not allowed — Document head in use.'
			]);
			return;
        }

		// Convert 'Active' to 0 and anything else to 1
		if($status=='1') {
			$new_status ='0';
		} else {
			$new_status = '1';	
		}
		$sql = "UPDATE sub_type SET status='$new_status' WHERE id='$id'";
		$query = $this->db->query($sql);

		if ($query) {
			echo json_encode([
				'success'    => true,
				'message'    => 'Status updated successfully.'
			]);
		} else {
			echo json_encode([
				'success' => false,
				'message' => 'Failed to update status.'
			]);
		}
	}
	 // 🔹 Private helper function to check if a record exists
    private function id_exists($table, $id)
    {
        return $this->db->where('type_id', $id)
                ->where('is_deleted', 0)
                ->limit(1)
                ->count_all_results($table) > 0;
    }

	public function reorder_all()
	{
		// Fetch all types in alphabetical order
		$sub_types = $this->db
			->where('status', '1') 
			->order_by('type_name', 'ASC')
			->get('sub_type')
			->result_array();

		foreach ($sub_types as &$row) {

			// Convert CSV IDs -> array
			$doc_ids = array_filter(array_map('trim', explode(',', $row['document_name'])));

			$documents = [];
			if (!empty($doc_ids)) {

				// Fetch documents IN THE SAME ORDER as stored sequence
				$doc_list = $this->db
					->where_in('id', $doc_ids)
					->where('status', '1')
					->get('documents')
					->result_array();

				// Index by ID for quick lookup
				$docIndexed = [];
				foreach ($doc_list as $d) {
					$docIndexed[$d['id']] = $d['document_name'];
				}

				// Keep ordering same as sub_type.document_name
				foreach ($doc_ids as $doc_id) {
					if (isset($docIndexed[$doc_id])) {
						$documents[] = [
							'id' => $doc_id,
							'name' => $docIndexed[$doc_id]
						];
					}
				}
			}

			// Attach final structured list
			$row['documents'] = $documents;
		}

		$data['sub_types'] = $sub_types;

		$this->load->view('templates/header');
		$this->load->view('type/reorder_all_view', $data);
		//$this->load->view('templates/footer');
	}

	public function save_order()
	{
		$type_id = $this->input->post('type_id');
		$sequence = $this->input->post('sequence');

		$docs = implode(',', $sequence);

		$this->db->where('id', $type_id)
				->update('sub_type', ['document_name' => $docs]);

		echo json_encode(['status' => 'success']);
	}
}
