<?php
defined('BASEPATH') OR exit('No direct script access allowed');

use PhpOffice\PhpSpreadsheet\Spreadsheet;
use PhpOffice\PhpSpreadsheet\Writer\Xlsx;

class Dashboard extends CI_Controller {



	public function __construct()
    {
        parent::__construct();
        $this->load->database();
        $this->load->helper(['url', 'form', 'download']);
        $this->load->library(['session', 'upload','zip']);
        //$this->load->model('Dashboard_model');
    } 
	/**
	 * Index Page for this controller.
	 *
	 * Maps to the following URL
	 * 		http://example.com/index.php/welcome
	 *	- or -
	 * 		http://example.com/index.php/welcome/index
	 *	- or -
	 * Since this controller is set as the default controller in
	 * config/routes.php, it's displayed at http://example.com/
	 *
	 * So any other public methods not prefixed with an underscore will
	 * map to /index.php/welcome/<method_name>
	 * @see https://codeigniter.com/userguide3/general/urls.html
	 */
	public function index()
	{
		redirect('dashboard/dashboard');
	}
	
	public function dashboard()
    {   
		$this->session->set_userdata('menu','Dashboard');
		$login_id = $this->session->userdata('id');
		if($login_id=='') {
			redirect('login');
		}

		//Total uploaded documents
		//$query = $this->db->get('uploaded_documents');
		$query = $this->db->get_where('uploaded_documents', ['is_deleted' => 0]);
		$resultComplete = $query->result_array();

		//Total uploaded documents with Document Names, Type Names and related Authoritys name
		$this->db->select('
			DISTINCT c.company_name,
			st.type_name,
			a.authority_name,
			d.document_name,
			st.frequency,
			ud.document_year,
			ud.document_month,
			ud.uploaded_at
		', FALSE);  // FALSE to prevent CI from escaping DISTINCT

		$this->db->from('uploaded_documents ud');
		$this->db->join('company c', 'ud.company_id = c.id', 'left');
		$this->db->join('sub_type st', 'ud.type_id = st.id', 'left');
		$this->db->join('authority a', 'CAST(st.authority_id AS INT) = a.id', 'left');
		$this->db->join('documents d', 'ud.document_id = d.id', 'left');
		$this->db->where('ud.is_deleted', 0);

		// ✅ Add ORDER BY fields (must be in SELECT list for DISTINCT)
		$this->db->order_by('c.company_name', 'ASC');
		$this->db->order_by('st.type_name', 'ASC');
		$this->db->order_by('ud.document_year', 'DESC');
		$this->db->order_by('ud.document_month', 'DESC');

		$query = $this->db->get();
		$resultDocComplete = $query->result();

		$groupedData = [];

		if (!empty($resultDocComplete)) {
			foreach ($resultDocComplete as $doc) {

				$key = $doc->company_name . '|' . $doc->authority_name . '|' . $doc->type_name . '|' . $doc->document_year . '|' . $doc->document_month;

				if (!isset($groupedData[$key])) {
					$groupedData[$key] = [
						'company_name' => $doc->company_name,
						'authority_name' => $doc->authority_name,
						'type_name' => $doc->type_name,
						'document_year' => $doc->document_year,
						'document_month' => $doc->document_month,
						'documents' => [],
						'uploaded_date' => $doc->uploaded_at,
						'frequency' =>$doc->frequency,
					];
				}
				$groupedData[$key]['documents'][] = $doc->document_name;
			}
		}

		$data['grouped_documents'] = $groupedData;
		//$this->load->view('documents_list', $data);

		/*	echo '<pre>';
		print_r($data);exit;	*/	

		//Upload pending documents
		$this->db->select('*');
		$this->db->from('sub_type');

		// Only rows where frequency_start_date has numeric values
		$this->db->where("frequency_start_date ~ '^[0-9]+$'", NULL, FALSE);

		// Main date comparison condition (wrapped in parentheses)
		$this->db->where("
			(
				(CAST(frequency_start_date AS INTEGER)
					BETWEEN EXTRACT(DAY FROM CURRENT_DATE)
					AND LEAST(EXTRACT(DAY FROM CURRENT_DATE) + 7, 31))
				OR
				(EXTRACT(DAY FROM CURRENT_DATE) + 7 > 31
					AND CAST(frequency_start_date AS INTEGER) <= (EXTRACT(DAY FROM CURRENT_DATE) + 7 - 31))
			)
		", NULL, FALSE);

		// Execute
		$queryP = $this->db->get();
		$resultPending = $queryP->result_array();

		//Due (date passed) documents
		$this->db->select('*');
		$this->db->from('sub_type');

		// Only numeric values
		$this->db->where("frequency_start_date ~ '^[0-9]+$'", NULL, FALSE);

		// Last 7 days calculation
		$this->db->where("
			(
				(CAST(frequency_start_date AS INTEGER)
					BETWEEN GREATEST(EXTRACT(DAY FROM CURRENT_DATE) - 7, 1)
					AND EXTRACT(DAY FROM CURRENT_DATE))
				OR
				(EXTRACT(DAY FROM CURRENT_DATE) - 7 < 1
					AND CAST(frequency_start_date AS INTEGER) >= (31 + (EXTRACT(DAY FROM CURRENT_DATE) - 7)))
			)
		", NULL, FALSE);

		$queryD = $this->db->get();
		$resultDues = $queryD->result_array();

		//Upcoming (Next month) documents
		$this->db->select('*');
		$this->db->from('sub_type');

		// Only numeric day values
		$this->db->where("frequency_start_date ~ '^[0-9]+$'", NULL, FALSE);

		// Only days 1–31
		$this->db->where("CAST(frequency_start_date AS INTEGER) BETWEEN 1 AND 31", NULL, FALSE);

		// Next month comparison
		$this->db->where("
			EXTRACT(MONTH FROM CURRENT_DATE) + 1 = 
			EXTRACT(MONTH FROM make_date(
				EXTRACT(YEAR FROM CURRENT_DATE)::int,
				EXTRACT(MONTH FROM CURRENT_DATE)::int + 1,
				CAST(frequency_start_date AS INTEGER)
			))
		", NULL, FALSE);

		// Execute query
		$queryUC = $this->db->get();
		$resultUpcoming = $queryUC->result_array();
		
		//Uploaded after due date documents

		/*echo '<pre>';
		print_r($result);exit;		*/
		$this->load->view('templates/header');
		$this->load->view('dashboard',array('show_documents'=>$groupedData,'complete_document'=>$resultComplete,'pending_document' =>$resultPending,'due_document'=> $resultDues,'upcoming_document'=>$resultUpcoming));
		$this->load->view('templates/footer');

	}
	public function faq() {
		$this->load->view('templates/layout');
		$this->load->view('faq');
		$this->load->view('templates/footer');
	}
	public function home() {
		$this->load->view('home');
	}
	public function userAccess() {
		$this->session->set_userdata('menu','access');
		$login_id = $this->session->userdata('id');
		if($login_id=='') {
			redirect('login');
		}
		
		$query = "select * from role where status='1'";
		$select_query = $this->db->query($query);	
		$role_data = $select_query->result_array();
		$this->load->view('templates/layout');
		$this->load->view('user_access',array('role_data'=>$role_data));
	}
	/*public function saveAccess() {
		$this->session->set_userdata('menu','access');
		$login_id = $this->session->userdata('id');
		if($login_id=='') {
			redirect('login');
		}
		$role_id = $_POST['role_id'];
		$view = implode(',',$_POST['view']);
		$edit = implode(',',$_POST['edit']);
		
		$user_query = "insert into user_priviledges (user_id, view, edit) values('$role_id','$view','$edit'	)";
		$user_sql = $this->db->query($user_query);
		
		$log_query ="insert into log_table(description, action, created_time, user_id) values('New User Added Successfully','New User Added','$created_date','$login_id')";
		$log_insert = $this->db->query($log_query);

		echo '<pre>'; print_r($_POST);exit;
	}*/

    // Logout function
	public function logout()
    {
        $session = session();
        $session->destroy();
        return redirect()->to('login');
    }
	
	public function changePassword() {
		$login_id = $this->session->userdata('id');
		if($login_id=='') {
			redirect('login');
		}
		$this->load->view('templates/layout');
		$this->load->view('change_password');
	}
	public function agree() {
		$login_id = $this->session->userdata('id');
		if($login_id=='') {
			redirect('login');
		}
		$id = $this->session->userdata('id');
		$sql="update users set verified = '1' where id= '$id'";
		$query = $this->db->query($sql);
		echo true;
	}
	public function getRoleAccess()
	{
		$role_id = $this->input->post('role_id');

		$access = $this->db->get_where('user_priviledges', ['role_id' => $role_id])->row();

		$view = [];
		$edit = [];

		if ($access) {
			if (!empty($access->view)) {
				$view = explode(',', str_replace(' ', '', $access->view));
			}
			if (!empty($access->edit)) {
				$edit = explode(',', str_replace(' ', '', $access->edit));
			}
		}

		echo json_encode(['view' => $view, 'edit' => $edit]);
	}
	public function saveAccess()
	{
		$role_id = $this->input->post('role_id');
		$view = $this->input->post('view');
		$edit = $this->input->post('edit');

		$view_str = is_array($view) ? implode(',', $view) : '';
		$edit_str = is_array($edit) ? implode(',', $edit) : '';

		$data = [
			'role_id' => $role_id,
			'view' => $view_str,
			'edit' => $edit_str
		];

		$existing = $this->db->get_where('role_access', ['role_id' => $role_id])->row();
		if ($existing) {
			$this->db->where('role_id', $role_id)->update('role_access', $data);
		} else {
			$this->db->insert('role_access', $data);
		}

		$this->session->set_flashdata('success', 'Access saved successfully!');
		redirect('dashboard/access');
	}
	public function updateSingleAccess()
	{
		$role_id = $this->input->post('role_id');
		$module = $this->input->post('module');
		$access_type = $this->input->post('access_type'); // view or edit
		$value = $this->input->post('value'); // 1 or 0

		$row = $this->db->get_where('user_priviledges', ['role_id' => $role_id])->row();

		$updated = [];

		if ($row) {
			$access_arr = explode(',', $row->$access_type);
			$access_arr = array_map('trim', $access_arr);

			if ($value == 1 && !in_array($module, $access_arr)) {
				$access_arr[] = $module;
			} elseif ($value == 0 && in_array($module, $access_arr)) {
				$access_arr = array_diff($access_arr, [$module]);
			}

			$updated[$access_type] = implode(',', $access_arr);
			$this->db->where('role_id', $role_id)->update('user_priviledges', $updated);
		} else {
			$updated = [
				'role_id' => $role_id,
				$access_type => $value ? $module : ''
			];
			$this->db->insert('user_priviledges', $updated);
		}

		echo 'success';
	}
	
	public function export_documents_excel()
	{
		$docs = $this->_getUploadedDocuments();
		if (ob_get_length()) ob_end_clean();
    	ini_set('zlib.output_compression', 'Off');
		
		$spreadsheet = new Spreadsheet();
    	$sheet = $spreadsheet->getActiveSheet();

		// Set header row
		$headers = ['S.No', 'Company', 'Authority', 'Document Type', 'Year', 'Month', 'Documents', 'Uploaded Date', 'Frequency'];
		$sheet->fromArray($headers, NULL, 'A1');

		// Bold header row
    	$sheet->getStyle('A1:I1')->getFont()->setBold(true);

		// Fill data
		$row = 2;
		foreach ($docs as $doc) {
			$documentList = !empty($doc['documents']) ? implode(', ', $doc['documents']) : '';

			// Convert month number to month name
			$monthNum = (int)$doc['document_month'];
			$monthName = '';
			if ($monthNum >= 1 && $monthNum <= 12) {
				$monthName = date('F', mktime(0, 0, 0, $monthNum, 10)); // e.g., 1 → January
			} else {
				$monthName = $doc['document_month']; // fallback in case of invalid month
			}
			
			$sheet->setCellValue("A$row", $row-1);
			$sheet->setCellValue("B$row", $doc['company_name']);
			$sheet->setCellValue("C$row", $doc['authority_name']);
			$sheet->setCellValue("D$row", $doc['type_name']);
			$sheet->setCellValue("E$row", $doc['document_year']);
			$sheet->setCellValue("F$row", $monthName);
			$sheet->setCellValue("G$row", $documentList);
			$sheet->setCellValue("H$row", $doc['uploaded_date']);
			$sheet->setCellValue("I$row", $doc['frequency']);

			$row++;
		}
		// Auto-size columns
		foreach (range('A', 'I') as $col) {
			$sheet->getColumnDimension($col)->setAutoSize(true);
		}

		// Set filename
		$filename = 'documents_list_' . date('Y-m-d') . '.xlsx';

		// Send headers to browser
		header('Content-Type: application/vnd.openxmlformats-officedocument.spreadsheetml.sheet');
		header('Content-Disposition: attachment; filename="' . $filename . '"');
		header('Cache-Control: max-age=0');

		$writer = new Xlsx($spreadsheet);
		$writer->save('php://output');
		exit;
	}

	private function _getUploadedDocuments(){
		//Total uploaded documents with Document Names, Type Names and related Authoritys name
		$this->db->select('
			DISTINCT c.company_name,
			st.type_name,
			a.authority_name,
			d.document_name,
			st.frequency,
			ud.document_year,
			ud.document_month,
			ud.uploaded_at
		', FALSE);  // FALSE to prevent CI from escaping DISTINCT

		$this->db->from('uploaded_documents ud');
		$this->db->join('company c', 'ud.company_id = c.id', 'left');
		$this->db->join('sub_type st', 'ud.type_id = st.id', 'left');
		$this->db->join('authority a', 'CAST(st.authority_id AS INT) = a.id', 'left');
		$this->db->join('documents d', 'ud.document_id = d.id', 'left');
		$this->db->where('ud.is_deleted', 0);

		// ✅ Add ORDER BY fields (must be in SELECT list for DISTINCT)
		$this->db->order_by('c.company_name', 'ASC');
		$this->db->order_by('st.type_name', 'ASC');
		$this->db->order_by('ud.document_year', 'DESC');
		$this->db->order_by('ud.document_month', 'DESC');

		$query = $this->db->get();
		$resultDocComplete = $query->result();

		$groupedData = [];

		if (!empty($resultDocComplete)) {
			foreach ($resultDocComplete as $doc) {

				$key = $doc->company_name . '|' . $doc->authority_name . '|' . $doc->type_name . '|' . $doc->document_year . '|' . $doc->document_month;

				if (!isset($groupedData[$key])) {
					$groupedData[$key] = [
						'company_name' => $doc->company_name,
						'authority_name' => $doc->authority_name,
						'type_name' => $doc->type_name,
						'document_year' => $doc->document_year,
						'document_month' => $doc->document_month,
						'documents' => [],
						'uploaded_date' => $doc->uploaded_at,
						'frequency' =>$doc->frequency,
					];
				}
				$groupedData[$key]['documents'][] = $doc->document_name;
			}
		}
		return $groupedData;
	}
}
